<?php get_header(); ?>

<div id="content" class="<?php if(get_option('smartblog_homepage_layout') == 'Content | Sidebar') { echo('left'); } else { echo('right'); } ?>">

	<?php include(TEMPLATEPATH. '/includes/templates/breadcrumbs.php'); ?>

	<?php the_post(); ?>
	
	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			
		<h1 class="entry-title"><?php the_title(); ?></h1>
		
		<div class="entry-meta">
		
			<span class="left">
				 <span class="meta-sep">|</span> <?php _e('Escrito o:', 'themejunkie'); ?> <span class="meta-date"><abbr class="published" title="<?php the_time('g:i a'); ?>"><?php the_time(get_option('date_format')); ?></abbr></span>
			</span>
			
			<span class="entry-comment">
				<?php comments_popup_link( __( 'Ningún comentario', 'themejunkie' ), __( '1 comentario', 'themejunkie' ), __( '% comentarios', 'themejunkie' ) ); ?>
			</span>
		
		<div class="clear"></div>
		
		</div> <!--end .entry-meta-->
		
		<div class="entry entry-content">
		
			<?php if(get_option('smartblog_integrate_singletop_enable') == 'on') echo (get_option('smartblog_integration_single_top')); ?>
		
			<?php the_content(); ?>

<a href="http://cabozo.com/share.php?url=<?php the_permalink(); ?>" TARGET='_blank'><img src="http://www.cabozo.com/imagenesweb/difundir.png" alt=""  style="border:none" title="Difundir a nova en Cabozo"  /></a>


			<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'themejunkie' ), 'after' => '</div>' ) ); ?>
		
			<?php if(get_option('smartblog_integrate_singlebottom_enable') == 'on') echo (get_option('smartblog_integration_single_bottom')); ?>
		
		</div> <!--end .entry-->

		<?php printf(the_tags(__('<div class="entry-tags"><span>Tags:</span>&nbsp;','themejunkie'),', ','</div>')); ?>
		
		<?php if(get_option('smartblog_retweet_button_enable') == 'on') { ?>

			<span class="right"><a href="http://twitter.com/share" class="twitter-share-button" data-count="horizontal" data-text="<?php the_title();?>" data-url="<?php the_permalink();?>"><?php _e('Tweet','themejunkie'); ?></a><script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script></span>

		<?php } ?>

		<div class="clear"></div>
		
		<?php if(get_option('smartblog_show_author_box') == 'on') { ?> 
		
			<div class="entry-author clear">
				<div class="author-avatar">
				<?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'themejunkie_author_bio_avatar_size', 60 ) ); ?>
				</div> <!--end .author-avatar-->
				<div class="author-description">
					<h3><?php the_author(); ?></h3>
					<?php the_author_meta( 'description' ); ?>
					<div id="author-link">
						<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" title="<?php printf( esc_attr__( 'Ver todas as entradas de %s', 'themejunkie' ), get_the_author() ); ?>"><?php _e( 'Ver todas as entradas de ', 'themejunkie' ); ?><?php the_author(); ?> &rarr;</a>
					</div> <!--end .author-link-->
				</div> <!--end .author-description-->
			</div> <!--end .entry-author-->
			
		<?php } ?>
		
		<?PHP if(get_option('smartblog_show_related_ad_box') == 'on') { ?>
		
			<div class="entry-bottom">
						
				<div class="related-posts">
					<?php tj_related_posts(); ?>
				</div><!--end .related-posts-->
				
				<?PHP if(get_option('smartblog_entry_bottom_ad_enable') == 'on') { ?>
					<div class="entry-bottom-ad">
						<h3 class="ad-title"><?php _e('Advertisement','themejunkie'); ?></h3>
						<?php echo get_option('smartblog_entry_bottom_ad_code'); ?>
					</div><!--end .entry-bottom-ad-->
				<?php } ?>
				
				<div class="clear"></div>
			
			</div><!--end .entry-bottom-->

		<?php } ?>
		

	</div> <!--end #post-->

	<?php if(get_option('smartblog_show_post_comments') == 'on') comments_template( '', true ); ?>

</div><!--end #content-->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
