<?php

// Translations can be filed in the /lang/ directory
load_theme_textdomain( 'themejunkie', TEMPLATEPATH . '/lang' );	

require_once(TEMPLATEPATH . '/includes/sidebar-init.php');
require_once(TEMPLATEPATH . '/includes/custom-functions.php'); 
require_once(TEMPLATEPATH . '/includes/post-thumbnails.php'); 

require_once(TEMPLATEPATH . '/includes/theme-options.php');
require_once(TEMPLATEPATH . '/includes/theme-comments.php'); 
require_once(TEMPLATEPATH . '/includes/theme-widgets.php');

require_once(TEMPLATEPATH . '/functions/theme_functions.php'); 
require_once(TEMPLATEPATH . '/functions/admin_functions.php');

    function rarst_twitter_user( $username, $field, $display = false ) {
    $interval = 3600;
    $cache = get_option('rarst_twitter_user');
    $url = 'http://api.twitter.com/1/users/show.json?screen_name='.urlencode($username);

    if ( false == $cache )
    $cache = array();

    // if first time request add placeholder and force update
    if ( !isset( $cache[$username][$field] ) ) {
    $cache[$username][$field] = NULL;
    $cache[$username]['lastcheck'] = 0;
    }

    // if outdated
    if( $cache[$username]['lastcheck'] < (time()-$interval) ) {

    // holds decoded JSON data in memory
    static $memorycache;

    if ( isset($memorycache[$username]) ) {
    $data = $memorycache[$username];
    }
    else {
    $result = wp_remote_retrieve_body(wp_remote_request($url));
    $data = json_decode( $result );
    if ( is_object($data) )
    $memorycache[$username] = $data;
    }

    if ( is_object($data) ) {
    // update all fields, known to be requested
    foreach ($cache[$username] as $key => $value)
    if( isset($data->$key) )
    $cache[$username][$key] = $data->$key;

    $cache[$username]['lastcheck'] = time();
    }
    else {
    $cache[$username]['lastcheck'] = time()+60;
    }

    update_option( 'rarst_twitter_user', $cache );
    }

    if ( false != $display )
    echo $cache[$username][$field];
    return $cache[$username][$field];
    }


?>