<?php
/*
Plugin Name: WP Float
Plugin URI: http://webwiki.co/plugins-widgets/64-wp-float-plugin
Description: Add a fixed/float text,image or HTML to WordPress
Author: Sam Hagin
Version: 1.2
Author URI: http://webwiki.co
*/
/*  Copyright 2011 Sam Hagin (email : admin@webwiki.co)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


//Plugin requires WordPress 3.3 or higher
function wp_float_requires_wordpress_version() {
        global $wp_version;
        $plugin = plugin_basename( __FILE__ );
        $plugin_data = get_plugin_data( __FILE__, false );

        if ( version_compare($wp_version, "3.3", "<" ) ) {
                if( is_plugin_active($plugin) ) {
                        deactivate_plugins( $plugin );
                        wp_die( "'".$plugin_data['Name']."' requires WordPress 3.3 or higher, and has
been deactivated! Please upgrade WordPress and try again.<br /><br />Back to <a
href='".admin_url()."'>WordPress admin</a>." );
                }
        }
}
add_action( 'admin_init', 'wp_float_requires_wordpress_version' );


// Set-up Action and Filter Hooks
register_uninstall_hook(__FILE__, 'wp_sh_delete_plugin_options');
add_action('admin_init', 'wp_sh_float_init');
add_action('admin_menu', 'wp_sh_float_menu');



// Delete options table entries ONLY when plugin deactivated AND deleted
function wp_sh_delete_plugin_options() {
        delete_option('wp_sh_float_options');
}


function wp_sh_float_init() {
        register_setting('wp_sh_float_options', 'wp_sh_float_options');
        add_settings_field('wp_sh_float_html', 'WP Float Code', 'wp_sh_float_html_fn', __FILE__);
        add_settings_field('wp_sh_float_leftright', 'Float Position', 'wp_sh_float_leftright_fn', __FILE__);
        add_settings_field('wp_sh_float_topbottom', 'Top/Bottom Position', 'wp_sh_float_topbottom_fn', __FILE__);
        add_settings_field('wp_sh_float_center', 'Center', 'wp_sh_float_center_fn', __FILE__);
        add_settings_field('wp_sh_float_height', 'Height', 'wp_sh_float_height_fn', __FILE__);
        add_settings_field('wp_sh_float_width', 'Width', 'wp_sh_float_width_fn', __FILE__);
        add_settings_field('wp_sh_float_lrdistance', 'Distance From Left/Right', 'wp_sh_float_lrdistance_fn', __FILE__);
        add_settings_field('wp_sh_float_tbdistance', 'Distance From Top/Bottom', 'wp_sh_float_tbdistance_fn', __FILE__);
        add_settings_field('wp_sh_float_fixed', 'Type', 'wp_sh_float_fixed_fn', __FILE__);
        add_settings_field('wp_sh_float_home', 'Show on Homepage', 'wp_sh_float_home_fn', __FILE__);
        add_settings_field('wp_sh_float_single', 'Show on Posts', 'wp_sh_float_single_fn', __FILE__);
        add_settings_field('wp_sh_float_pages', 'Show on Pages', 'wp_sh_float_pages_fn', __FILE__);
}



//Add Admin Menu
function wp_sh_float_menu() {
        add_options_page('WP Float Options', 'WP Float Options', 'manage_options',__FILE__, 'wp_sh_float_options');

        }

function wp_sh_float_options() {
        if (!current_user_can('manage_options'))  {
                wp_die( __('You do not have sufficient permissions to access this page.') );

           } ?>
<div class="wrap">

                <!-- Display Plugin Icon, Header, and Description -->
                <div class="icon32" id="icon-options-general"><br></div>
                <h2>WP Float Options</h2>
                <p></p>

                <!-- Beginning of the Plugin Options Form -->
                <form method="post" action="options.php">
                        <?php settings_fields('wp_sh_float_options'); ?>
                        <?php $options = get_option('wp_sh_float_options'); ?>

                        <!-- Table Structure Containing Form Controls -->
                        <table>


                                <!-- Text Area Using the Built-in WP Editor -->

                                                <tr><td><b><h3>WP Float Content</h3></b><?php
                                                                $args = array(
                                                                "textarea_name" => "wp_sh_float_options[wp_sh_float_html]",
                                                                'wpautop' => true,
                                                                'textarea_rows' => get_option('default_post_edit_rows', 10),
                                                                'tinymce' => true,
                                                                'mode' => 'exact',
                                                                'weight' => 200, );
                                                wp_editor( $options['wp_sh_float_html'], "wp_sh_float_options[wp_sh_float_html]", $args );
                                                        ?>
                                                <br /><span style="color:#666666;margin-left:2px;">Add the content you want to float on
                                        your site. This can be HTML, an image or any text.</span>
                        </td>
                        </tr>




<tr><td><b>Type</b>
<?php
          //Float or Fixed
        $floatfixed = array('Float', 'Fixed');
        echo "<select  name='wp_sh_float_options[wp_sh_float_fixed]'>";
        foreach($floatfixed as $floatfixed) {
        $selected = ($options['wp_sh_float_fixed']==$floatfixed) ? 'selected="selected"' : '';
        echo "<option value='$floatfixed' $selected>$floatfixed</option>";
        }
        echo "</select>";

?>
<tr><td><b>Position</b>
<?php
        //Left/Right Position
        $items = array('Left', 'Right');
        echo "<select  name='wp_sh_float_options[wp_sh_float_leftright]'>";
        foreach($items as $item) {
        $selected = ($options['wp_sh_float_leftright']==$item) ? 'selected="selected"' : '';
                echo "<option value='$item' $selected>$item</option>";
        }

        echo "</select>";

        //Top/Bottom Position
        $tb = array('Top', 'Bottom');
        echo "<select  name='wp_sh_float_options[wp_sh_float_topbottom]'>";
        foreach($tb as $tb) {
        $selected = ($options['wp_sh_float_topbottom']==$tb) ? 'selected="selected"' : '';
                echo "<option value='$tb' $selected>$tb</option>";
        }

        echo "</select>";

        //Center Position
        $center = array('Do not center', 'Center Horizontally', 'Center Vertically');
        echo "<select  name='wp_sh_float_options[wp_sh_float_center]'>";
        foreach($center as $center) {
        $selected = ($options['wp_sh_float_center']==$center) ? 'selected="selected"' : '';
                echo "<option value='$center' $selected>$center</option>";
        }

        echo "</select>";



?>
<br /><span style="color:#666666;margin-left:2px;">Item Position. Centering only works when item is set to float.</span>

<tr><td><b>Distance From Left/Right</b>
<input type="text" size="1" name="wp_sh_float_options[wp_sh_float_lrdistance]" value="<?php echo $options['wp_sh_float_lrdistance']; ?>" />
<br /><span style="color:#666666;margin-left:2px;">Represents distance from left or right browser window in pixels</span>
</td></tr>

<tr><td><b>Distance From Top/Bottom</b>
<input type="text" size="1" name="wp_sh_float_options[wp_sh_float_tbdistance]" value="<?php echo $options['wp_sh_float_tbdistance']; ?>" />
<br /><span style="color:#666666;margin-left:2px;">Represents distance from top or bottom browser window in pixels</span>
</td></tr>

<tr><td><b>Height</b>
<input type="text" size="1" name="wp_sh_float_options[wp_sh_float_height]" value="<?php echo $options['wp_sh_float_height']; ?>" />

<b>Width</b>
<input type="text" size="1" name="wp_sh_float_options[wp_sh_float_width]" value="<?php echo $options['wp_sh_float_width']; ?>" />
<br /><span style="color:#666666;margin-left:2px;">Represents the height and width of the div that holds the item</span>
</td></tr>
    <tr><td>

<b>Display Options </b><br />
<input name="wp_sh_float_options[wp_sh_float_home]"  value="1" type="checkbox" <?php if (isset($options['wp_sh_float_home'])) { checked('1', $options['wp_sh_float_home']); } ?> />
<?php _e('Show on Homepage'); ?><br />
<input name="wp_sh_float_options[wp_sh_float_single]" type="checkbox" value="1" <?php if (isset($options['wp_sh_float_single'])) { checked('1', $options['wp_sh_float_single']); } ?> />
<?php _e('Show on Posts'); ?><br />
<input name="wp_sh_float_options[wp_sh_float_pages]" type="checkbox" value="1" <?php if (isset($options['wp_sh_float_pages'])) { checked('1', $options['wp_sh_float_pages']); } ?> />
<?php _e('Show on Pages'); ?><br />
<span style="color:#666666;margin-left:2px;">Check all options to display on homepage, pages and
posts</span>
</p>
</td></tr>

                        </table>
                        <p class="submit">
                        <input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>"
/>
                        </p>
                </form>


                <p style="margin-top:15px;">
                        <p style="font-style: italic; font-weight: bold;color: #26779a;">Need Help ? Check out the documentation for WP Float
at <a href="http://webwiki.co/plugins-widgets/64-wp-float-plugin" target="_blank">WebWiki.Co</a><br
?>If you have found this plugin  useful, please consider making a <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=CMGALCCS6UUZN"
target="_blank" >donation</a>. Thanks.</p>
                        <span><a href="http://www.facebook.com/pages/WebWikiCo/220588208033178" title="Our Facebook page" target="_blank"><img
style="border:1px #ccc solid;" src="<?php echo plugins_url(); ?>/wp-float/images/facebook.png" /></a></span>
                        &nbsp;&nbsp;<span><a href="http://www.twitter.com/webhost123" title="Follow on Twitter"
target="_blank"><img style="border:1px #ccc solid;" src="<?php echo plugins_url();
?>/wp-float/images/twitter.png" /></a></span>
                        &nbsp;&nbsp;<span><a href="http://webwiki.co" title="WebWiki.Co" target="_blank"><img
style="border:1px #ccc solid;" src="<?php echo plugins_url(); ?>/wp-float/images/website.png" /></a></span>
                </p>

<?php


        }


$data=get_option('wp_sh_float_options');

if (($data['wp_sh_float_fixed']) == 'Float') {

add_action('wp_head', 'wp_sh_float_php'); //Add action to header

function wp_sh_float_php(){
global $data;
if (is_home() && isset($data['wp_sh_float_home']) && $data['wp_sh_float_home'] == 1 || is_single() && isset($data['wp_sh_float_single']) && $data['wp_sh_float_single'] == 1 || is_page() && isset($data['wp_sh_float_pages']) && $data['wp_sh_float_pages'] == 1 || is_front_page() && isset($data['wp_sh_float_home']) && $data['wp_sh_float_home'] == 1) {
//If distance from left/right/top/bottom is not definded
               // $data=get_option('wp_sh_float_options');
                if (($data['wp_sh_float_lrdistance']) == '' )
                        $data['wp_sh_float_lrdistance']=0;
                if (($data['wp_sh_float_tbdistance']) == '' )
                       $data['wp_sh_float_tbdistance']=0;

?>
        <?php

        if (($data['wp_sh_float_center']) == 'Center Horizontally' ||  ($data['wp_sh_float_center']) == 'Center Vertically') {
                        echo '<div id="floatdiv" style="position:absolute; width:'.$data['wp_sh_float_width'].'px;height:'.$data['wp_sh_float_height'].'px; z-index:100">';

                }
        else {
                echo '<div id="floatdiv" style="position:absolute; width:'.$data['wp_sh_float_width'].'px;height:'.$data['wp_sh_float_height'].'px; z-index:100;';
                if (($data['wp_sh_float_leftright']) == 'Left')
                        echo "left: {$data['wp_sh_float_lrdistance']}px;\n";
                if (($data['wp_sh_float_leftright']) == 'Right')
                        echo "right:  {$data['wp_sh_float_lrdistance']}px;\n";
                if (($data['wp_sh_float_topbottom']) == 'Top')
                        echo "top: {$data['wp_sh_float_tbdistance']}px;\n";
                if (($data['wp_sh_float_topbottom']) == 'Bottom')
                        echo "bottom: {$data['wp_sh_float_tbdistance']}px;\n";
                        echo '">';
                }?>




        <!--Start of Float-->
        <?php echo $data['wp_sh_float_html'].'<br />'; ?>
        <!--End of Float-->


        <!--Close Button Work In Progress--
        <a href="#" onclick="return floatingMenu.hide()"><img
        src="button.gif" /></a>
        -->

        </div>

    <script type="text/javascript">
        floatingMenu.add('floatdiv',
            {
                <?php
                if (($data['wp_sh_float_leftright']) == 'Left')
                        echo "targetLeft: {$data['wp_sh_float_lrdistance']},\n";
                if (($data['wp_sh_float_leftright']) == 'Right')
                        echo "targetRight:  {$data['wp_sh_float_lrdistance']},\n";
                if (($data['wp_sh_float_topbottom']) == 'Top')
                        echo "targetTop: {$data['wp_sh_float_tbdistance']},\n";
                if (($data['wp_sh_float_topbottom']) == 'Bottom')
                        echo "targetBottom: {$data['wp_sh_float_tbdistance']},\n";
                if (($data['wp_sh_float_center']) == 'Center Horizontally')
                        echo "centerX: true,\n";
                if (($data['wp_sh_float_center']) == 'Center Vertically')
                        echo "centerY: true,\n";

                ?>

                // Represents distance from left or right browser window
                // border depending upon property used. Only one should be
                // specified.
                //targetLeft: 10,
                //targetRight: 10,

                // Represents distance from top or bottom browser window
                // border depending upon property used. Only one should be
                // specified.
                //targetTop: 10,
                 //targetBottom: 0,

                // Uncomment one of those if you need centering on
                // X- or Y- axis.
                // centerX: true,
                // centerY: true,

                // Remove this one if you don't want snap effect
                 snap: true

                });
    </script>
<!---Close Button-->

<script type="text/javascript"><!--
/* Script by: www.jtricks.com
 * Version: 20110107
 * Latest version:
 * www.jtricks.com/javascript/navigation/floating_close.html
 */
floatingMenu.hide = function()
{
    floatingArray[0].menu.style.visibility='hidden';
    return false;
}

floatingMenu.show = function()
{
    floatingArray[0].menu.style.visibility='';
    return false;
}

//--></script>

<!--End of Close Button-->

<?php
    }
 }  //Load wp-float function
function wp_sh_float_js () {
$path = plugins_url('/wp-float/');
wp_register_script('wp_sh_float',$path. 'js/wp-float.js');
wp_enqueue_script('wp_sh_float');
}  //Function to enqueue jquery
add_action('wp_enqueue_scripts','wp_sh_float_js'); //Enqueue scripts
}?>
<?php
if (($data['wp_sh_float_fixed']) == 'Fixed') {

add_action('wp_head', 'wp_sh_float_php'); //Add action to header

function wp_sh_float_php(){
global $data;
if (is_home() && isset($data['wp_sh_float_home']) && $data['wp_sh_float_home'] == 1 || is_single() && isset($data['wp_sh_float_single']) && $data['wp_sh_float_single'] == 1 || is_page() && isset($data['wp_sh_float_pages']) && $data['wp_sh_float_pages'] == 1 || is_front_page() && isset($data['wp_sh_float_home']) && $data['wp_sh_float_home'] == 1) {

//If distance from left/right/top/bottom is not definded
                //$data=get_option('wp_sh_float_options');
                if (($data['wp_sh_float_lrdistance']) == '' )
                        $data['wp_sh_float_lrdistance']=0;
                if (($data['wp_sh_float_tbdistance']) == '' )
                       $data['wp_sh_float_tbdistance']=0;

                echo '<div id="fixeddiv" style="position:fixed; width:'.$data['wp_sh_float_width'].'px;height:'.$data['wp_sh_float_height'].'px;';
                if (($data['wp_sh_float_leftright']) == 'Left')
                        echo "left: {$data['wp_sh_float_lrdistance']}px;\n";
                if (($data['wp_sh_float_leftright']) == 'Right')
                        echo "right:  {$data['wp_sh_float_lrdistance']}px;\n";
                if (($data['wp_sh_float_topbottom']) == 'Top')
                        echo "top: {$data['wp_sh_float_tbdistance']}px;\n";
                if (($data['wp_sh_float_topbottom']) == 'Bottom')
                        echo "bottom: {$data['wp_sh_float_tbdistance']}px;\n";
                        echo '">';
                ?>




        <!--Start of Float-->
        <?php echo $data['wp_sh_float_html'].'<br />'; ?>
        <!--End of Float-->

        </div>


<?php
  }
        } //Load wp-float function


function wp_sh_float_js () {
$path = plugins_url('/wp-float/');
wp_register_script('wp_sh_float',$path. 'js/wp-float-fixed.js');
wp_enqueue_script('wp_sh_float');
                }  //Function to enqueue jquery
add_action('wp_enqueue_scripts','wp_sh_float_js'); //Enqueue scripts
        }
?>
