<?php  
##################################################################
# removes meta tag "generated by wordpress" for security purpose
# and add Version number of the theme and theme framework to a meta 
# tag for easier debugging by the author, in case of help requests
##################################################################

function khelper_generator()
{ 	
	$metatags = '';
	
	if (!is_feed())
	{
		$metatags .= "\n\n";
		$metatags .= '<!-- Debugging help, do not remove -->'."\n";
		$metatags .= '<meta name="Framework" content="Kpress" />'."\n";
		$metatags .= '<meta name="Theme Version" content="'.THEMEVERSION.'" />'."\n";
		$metatags .= '<meta name="Framework Version" content="'.FRAMEWORK_VERSION.'" />'."\n";
		$metatags .= '<meta name="CMS Version" content="'.get_bloginfo('version').'" />'."\n\n";
	}
	return $metatags;
}  
add_filter('the_generator','khelper_generator');


##################################################################
# prevents duplicate content by setting archive pages to nofollow
##################################################################
function khelper_follow_nofollow()
{
	if ((is_single() || is_page() || is_home() ) && ( !is_paged() )) 
	{
		echo '<meta name="robots" content="index, follow" />' . "\n";
	} 
	else 
	{
		echo '<meta name="robots" content="noindex, follow" />' . "\n";
	}
}

##################################################################
# check if the current page has a custom widget and set a global
# var if that the case
##################################################################
function check_custom_widget()
{	
	global $custom_widget_area, $k_option;
	//special widget area
	$specialpage = explode(',',$k_option['includes']['multi_widget_final']);
	$specialcat = explode(',',$k_option['includes']['multi_widget_cat_final']); 
	
	if(is_page($specialpage))
	{	
		$custom_widget_area = get_the_title();
	}
	else if(is_category($specialcat) || ($k_option['includes']['single_post_multi_widget_cat'] != 2 && in_category($specialcat)))
	{	
		$custom_widget_area = get_the_category();
		$custom_widget_area = $custom_widget_area[0]->cat_name;
	}
	
}
add_action('wp_head', 'check_custom_widget');

##################################################################
# match file extension of a url or path against array
##################################################################

function kriesi_is_file($needle, $haystack)
{	
	// get file extension
	$needle = substr($needle, strrpos($needle, '.') + 1);
	
	//no file, return false
	if(strlen($needle) > 4) return false;
	
	//predefined arrays
	if(!is_array($haystack))
	{
		switch($haystack)
		{
			case 'image':
				$haystack = array('png','gif','jpeg','jpg','pdf','tif');
			break;
			
			case 'text':
				$haystack = array('doc','docx','rtf','ttf','txt','odp');
			break;
		}
	}
	
	//match extension against array
	if (in_array($needle,$haystack))
	{
		return true;
	}
	else
	{
		return false;
	}
	
}



##################################################################
# Remove Blog categories from widget
##################################################################

function filter_category($cat_args)
{
	global $k_option;
	
	if($k_option['blog']['blog_widget_exclude'] == 1)
	{
		$cat_args['exclude'] = $k_option['blog']['blog_cat_final'];
	}
	else if($k_option['mainpage']['blog_widget_exclude'] == 1)
	{
		$cat_args['exclude'] = $k_option['mainpage']['main_cat_final'];
	}
	
 	return $cat_args;
}

add_filter('widget_categories_args', 'filter_category');


##################################################################
# Debuging helper
##################################################################
function debug_help()
{	
	global $k_option;
	echo'<div style="font-size:16px; clear:both;">';
	echo 'Wordpress Version: '.get_bloginfo('version');
	//resizing
	echo '<br/>Resizing: '.intval($k_option['custom']['resizing']);
	echo '<br/>GD_lib: '.intval($k_option['custom']['gd']);
	echo '<br/>Caching: '.intval($k_option['custom']['caching']);
	// phpinfo
	phpinfo();
	echo "</div>";
}
if(isset($_GET['debug']) && sha1($_GET['debug']) =='cf2045ce10e95d2d6288346897c415308b271f77') add_action ('shutdown','debug_help');

##################################################################
# Timthumbresizing possible?
##################################################################

function check_resizing()
{
	global $k_option;
	$cachepath = TEMPLATEPATH."/cache/";
	
	$k_option['custom']['resizing'] = false;
	$k_option['custom']['gd'] = false;
	$k_option['custom']['caching'] = false;
	
	if(function_exists("gd_info")) $k_option['custom']['gd'] = true;
	if(is_writeable($cachepath)) $k_option['custom']['caching'] = true;
	if($k_option['custom']['gd'] && $k_option['custom']['caching']) $k_option['custom']['resizing'] = true;
}
add_action('init', 'check_resizing');

##################################################################
# Add different Post Thumb Image sizes 
##################################################################
function k_add_image_size()
{	
	global $k_option;
	if (function_exists('add_theme_support')) { 
		add_theme_support('post-thumbnails');
		
		foreach ($k_option['custom']['imgSize'] as $sizeName => $size)
		{
			if($sizeName == 'base')
			{
				set_post_thumbnail_size($k_option['custom']['imgSize'][$sizeName]['width'], $k_option['custom']['imgSize'][$sizeName]['height'], true);
			}
			else
			{	
				add_image_size(	 
					$sizeName,
					$k_option['custom']['imgSize'][$sizeName]['width'], 
					$k_option['custom']['imgSize'][$sizeName]['height'], 
					true);
			}
		}
	}
}
k_add_image_size();


