<?php
/**
 * The Display options Meta-box configurations.
 *
 * @package Smart_Post_Show
 * @subpackage Smart_Post_Show/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.

/**
 * The Layout building class.
 */
class SPS_Display {

	/**
	 * Display options section metabox.
	 *
	 * @param string $prefix The metabox key.
	 * @return void
	 */
	public static function section( $prefix ) {
		SP_PC::createSection(
			$prefix,
			array(
				'title'  => __( 'DISPLAY Settings', 'post-carousel' ),
				'icon'   => 'sps-icon-display-s',
				'fields' => array(
					array(
						'type'  => 'tabbed',
						'class' => 'pcp-display-tabs',
						'tabs'  => array(
							array(
								'title'  => __( 'Basic Styles', 'post-carousel' ),
								'icon'   => '<i class="sps-icon-basic-style-01-1" aria-hidden="true"></i>',
								'fields' => array(
									array(
										'id'         => 'section_title',
										'type'       => 'switcher',
										'title'      => __( 'Section Title ', 'post-carousel' ),
										'subtitle'   => __( 'Show/Hide item showcase section title.', 'post-carousel' ),
										'default'    => false,
										'text_on'    => __( 'Show', 'post-carousel' ),
										'text_off'   => __( 'Hide', 'post-carousel' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'pcp_number_of_columns',
										'type'       => 'column',
										'title'      => __( 'Column(s)', 'post-carousel' ),
										'subtitle'   => __(
											'Set number of column(s) in different responsive devices.',
											'post-carousel'
										),
										'sanitize'   => 'spf_pcp_sanitize_number_array_field',
										'default'    => array(
											'lg_desktop' => '4',
											'desktop'    => '4',
											'tablet'     => '3',
											'mobile_landscape' => '2',
											'mobile'     => '1',
										),
										'min'        => '1',
										'decimal'    => true,
										'title_info' => '<i class="fa fa-television"></i> ' . __( 'Large Desktop - is larger than 1200px', 'post-carousel' ) . ',<br><i class="fa fa-desktop"></i> ' . __( 'Desktop - size is larger than 992px', 'post-carousel' ) . ',<br> <i class="fa fa-tablet"></i> ' . __( 'Tablet - Size is larger than 768', 'post-carousel' ) . ',<br> <i class="fa fa-mobile"></i> ' . __( 'Mobile Landscape- size is larger than 576px.', 'post-carousel' ) . ',<br> <i class="fa fa-mobile"></i> ' . __( 'Mobile - size is smaller than 576px.', 'post-carousel' ),
										'dependency' => array( 'pcp_layout_preset', 'any', 'carousel_layout,thumbnails_slider,grid_layout,masonry_layout,glossary_layout,filter_layout,large_with_small', true ),
									),
									// array(
									// 'id'              => 'margin_between_post',
									// 'type'            => 'spacing',
									// 'title'           => __( 'Margin Between Columns', 'post-carousel' ),
									// 'subtitle'        => __( 'Set margin between columns (items).', 'post-carousel' ),
									// 'sanitize'        => 'spf_pcp_sanitize_number_array_field',
									// 'all'             => true,
									// 'all_icon'        => '<i class="fa fa-arrows-h"></i>',
									// 'units'           => array(
									// 'px',
									// ),
									// 'all_placeholder' => 'margin',
									// 'default'         => array(
									// 'all' => '20',
									// ),
									// ),
									array(
										'id'              => 'margin_between_post',
										'type'            => 'spacing',
										'title'           => __( 'Space', 'post-carousel' ),
										'subtitle'        => __( 'Set space or gap between items.', 'post-carousel' ),
										'gap_between'     => true,
										'all_icon'        => '<i class="fa fa-arrows-h"></i>',
										'units'           => array(
											'px',
										),
										'all_placeholder' => '',
										'default'         => array(
											'top-bottom' => 20,
											'left-right' => 20,
										),
										'title_info'      => '<div class="spf-img-tag"><img src="' . SP_PC_URL . '/admin/img/visual-info/space.svg" alt="space"></div><div class="spf-info-label img">' . __( 'Space', 'post-carousel' ) . '</div>',
										'dependency'      => array( 'pcp_layout_preset', 'not-any', 'table_layout,slider_layout', true ),
									),
									array(
										'id'         => 'post_content_orientation',
										'type'       => 'layout_preset',
										'title'      => __( 'Content Orientation ', 'post-carousel' ),
										'subtitle'   => __( 'Set a position for the item content.', 'post-carousel' ),
										'desc'       => sprintf(
											/* translators: 1: start link and strong tag, 2: close tags. */
											__( 'To unlock more amazing Content Orientation and Layout based Settings, %1$sUpgrade To Pro!%2$s', 'post-carousel' ),
											'<a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><strong>',
											'</strong></a>'
										),
										'class'      => 'pcp-content-orientation',
										'options'    => array(
											'default'     => array(
												'image' => SP_PC_URL . 'admin/img/content-orientation/bottom.svg',
												'text'  => __( 'Default', 'post-carousel' ),
											),
											'left-thumb'  => array(
												'image'    => SP_PC_URL . 'admin/img/content-orientation/left.svg',
												'text'     => __( 'Left', 'post-carousel' ),
												'pro_only' => true,
											),
											'right-thumb' => array(
												'image'    => SP_PC_URL . 'admin/img/content-orientation/right.svg',
												'text'     => __( 'Right', 'post-carousel' ),
												'pro_only' => true,
											),
											'card'        => array(
												'image'    => SP_PC_URL . 'admin/img/content-orientation/card.svg',
												'text'     => __( 'Card', 'post-carousel' ),
												'pro_only' => true,
											),
											'overlay'     => array(
												'image'    => SP_PC_URL . 'admin/img/content-orientation/overlay.svg',
												'text'     => __( 'Overlay', 'post-carousel' ),
												'pro_only' => true,
											),
											'overlay-box' => array(
												'image'    => SP_PC_URL . 'admin/img/content-orientation/overlay_box.svg',
												'text'     => __( 'Overlay Box', 'post-carousel' ),
												'pro_only' => true,
											),
										),
										'default'    => 'default',
										'dependency' => array( 'pcp_layout_preset', 'not-any', 'slider_layout,list_layout', true ),
									),
									array(
										'id'         => 'overlay_content_position',
										'type'       => 'layout_preset',
										'only_pro'   => true,
										'class'      => 'hide-active-sign',
										'title'      => __( 'Content Position', 'post-carousel' ),
										'subtitle'   => __( 'Select a position for the overlay content.', 'post-carousel' ),
										'options'    => array(
											'middle' => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-content-position/middle.svg',
												'text'     => __( 'Middle', 'post-carousel' ),
												'pro_only' => true,
											),
											'top'    => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-content-position/top.svg',
												'text'     => __( 'Top', 'post-carousel' ),
												'pro_only' => true,
											),
											'bottom' => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-content-position/bottom.svg',
												'text'     => __( 'Bottom', 'post-carousel' ),
												'pro_only' => true,
											),
										),
										'default'    => 'middle',
										'dependency' => array( 'pcp_layout_preset|post_content_orientation', 'any|==', 'carousel_layout,grid_layout,masonry_layout,filter_layout,large_with_small,glossary_layout|overlay', true ),
									),
									array(
										'id'         => 'thumbnails_slider_content_position',
										'type'       => 'layout_preset',
										'class'      => 'thumbnails_slider_content_position hide-active-sign',
										'title'      => __( 'Content Position', 'post-carousel' ),
										'subtitle'   => __( 'Select a position for the overlay content.', 'post-carousel' ),
										'options'    => array(
											'middle'    => array(
												'image' => SP_PC_URL . 'admin/img/overlay-content-position/middle.svg',
												'text'  => __( 'Middle', 'post-carousel' ),
											),
											'top'       => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-content-position/top.svg',
												'text'     => __( 'Top', 'post-carousel' ),
												'pro_only' => true,
											),
											'bottom'    => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-content-position/bottom.svg',
												'text'     => __( 'Bottom', 'post-carousel' ),
												'pro_only' => true,
											),
											'in_middle' => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/inner_middle.svg',
												'text'     => __( 'Middle Box', 'post-carousel' ),
												'pro_only' => true,
											),
										),
										'default'    => 'middle',
										'dependency' => array( 'pcp_layout_preset', '==', 'slider_layout', true ),
									),
									array(
										'id'         => 'box_content_position',
										'type'       => 'layout_preset',
										'only_pro'   => true,
										'class'      => 'hide-active-sign',
										'title'      => __( 'Content Box Position', 'post-carousel' ),
										'subtitle'   => __( 'Select a position for the overlay content box.', 'post-carousel' ),
										'options'    => array(
											// 'in_top'       => __( 'Inner Top', 'post-carousel' ),
											// 'in_middle'    => __( 'Inner Middle', 'post-carousel' ),
											// 'in_bottom'    => __( 'Inner Bottom', 'post-carousel' ),
											// 'outer_top'    => __( 'Outer Top', 'post-carousel' ),
											// 'outer_right'  => __( 'Outer Right', 'post-carousel' ),
											// 'outer_bottom' => __( 'Outer Bottom', 'post-carousel' ),
											// 'outer_left'   => __( 'Outer Left', 'post-carousel' ),
											'in_middle'    => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/inner_middle.svg',
												'text'     => __( 'Inner Middle', 'post-carousel' ),
												'pro_only' => true,
											),
											'in_top'       => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/inner_top.svg',
												'text'     => __( 'Inner Top', 'post-carousel' ),
												'pro_only' => true,
											),
											'in_bottom'    => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/inner_bottom.svg',
												'text'     => __( 'Inner Bottom', 'post-carousel' ),
												'pro_only' => true,
											),
											'outer_top'    => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/outer_top.svg',
												'text'     => __( 'Outer Top', 'post-carousel' ),
												'pro_only' => true,
											),
											'outer_bottom' => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/outer_bottom.svg',
												'text'     => __( 'Outer Bottom', 'post-carousel' ),
												'pro_only' => true,
											),
											'outer_left'   => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/outer_left.svg',
												'text'     => __( 'Outer Left', 'post-carousel' ),
												'pro_only' => true,
											),
											'outer_right'  => array(
												'image'    => SP_PC_URL . 'admin/img/overlay-box-content-position/outer_right.svg',
												'text'     => __( 'Outer Right', 'post-carousel' ),
												'pro_only' => true,
											),
										),
										'default'    => 'in_middle',
										'dependency' => array( 'pcp_layout_preset|post_content_orientation', 'any|==', 'carousel_layout,grid_layout,masonry_layout,filter_layout,glossary_layout,large_with_small|overlay-box', true ),
									),
									array(
										'id'         => 'post_overlay_content_visibility',
										'type'       => 'button_set',
										'class'      => 'pro-overlay-options',
										'only_pro'   => true,
										'inline'     => true,
										'title'      => __( 'Content Visibility', 'post-carousel' ),
										'subtitle'   => __( 'Choose a visibility type for overlay content.', 'post-carousel' ),
										'options'    => array(
											'always'   => __( 'Always', 'post-carousel' ),
											'on_hover' => __( 'On Hover', 'post-carousel' ),
										),
										'default'    => 'on_hover',
										'title_info' => '<div class="spf-img-tag"><img src="' . SP_PC_URL . '/admin/img/visual-info/overlay_content_visibility.svg" alt="overlay_content_visibility"></div><div class="spf-info-label img">' . __( 'Overlay Content Visibility', 'post-carousel' ) . '</div>',
										'dependency' => array( 'pcp_layout_preset|post_content_orientation', 'any|any', 'carousel_layout,grid_layout,masonry_layout,filter_layout,glossary_layout,large_with_small,thumbnails_slider,slider_layout|overlay-box,overlay', true ),
									),
									array(
										'id'         => 'post_animation',
										'type'       => 'select',
										'class'      => 'pro-overlay-options',
										'only_pro'   => true,
										'title'      => __( 'Hover Animation', 'post-carousel' ),
										'subtitle'   => __( 'Select an animation type for the overlay content on hover.', 'post-carousel' ),
										'options'    => array(
											'none'         => __( 'None', 'post-carousel' ),
											'fadeIn'       => __( 'fadeIn', 'post-carousel' ),
											'fadeInDown'   => __( 'fadeInDown', 'post-carousel' ),
											'fadeInRight'  => __( 'fadeInRight', 'post-carousel' ),
											'fadeInLeft'   => __( 'fadeInLeft', 'post-carousel' ),
											'fadeInUp'     => __( 'fadeInUp', 'post-carousel' ),
											'flipInX'      => __( 'flipInX', 'post-carousel' ),
											'flipInY'      => __( 'flipInY', 'post-carousel' ),
											'slideInUp'    => __( 'slideInUp', 'post-carousel' ),
											'slideInDown'  => __( 'slideInDown', 'post-carousel' ),
											'zoomIn'       => __( 'zoomIn', 'post-carousel' ),
											'zoomInDown'   => __( 'zoomInDown', 'post-carousel' ),
											'jackInTheBox' => __( 'jackInTheBox', 'post-carousel' ),
											'rollIn'       => __( 'rollIn', 'post-carousel' ),
										),
										'default'    => 'zoomIn',
										'dependency' => array( 'pcp_layout_preset|post_content_orientation|post_overlay_content_visibility', 'any|any|==', 'carousel_layout,grid_layout,masonry_layout,filter_layout,glossary_layout,large_with_small,thumbnails_slider,slider_layout|overlay,overlay-box|on_hover' ),
									),
									array(
										'id'         => 'post_overlay_background_type',
										'only_pro'   => true,
										'type'       => 'button_set',
										'class'      => 'pro-overlay-options',
										'title'      => __( 'Overlay Color Type', 'post-carousel' ),
										'subtitle'   => __( 'Choose an overlay color type.', 'post-carousel' ),
										'options'    => array(
											'solid'    => __( 'Solid', 'post-carousel' ),
											'gradient' => __( 'Gradient', 'post-carousel' ),
										),
										'default'    => array( 'solid' ),
										'dependency' => array( 'pcp_layout_preset|post_content_orientation', 'any|any', 'carousel_layout,grid_layout,masonry_layout,filter_layout,glossary_layout,large_with_small,thumbnails_slider,slider_layout|overlay-box,overlay', true ),
									),
									array(
										'id'            => 'post_border',
										'type'          => 'border',
										'title'         => __( 'Border', 'post-carousel' ),
										'subtitle'      => __( 'Set border for the item.', 'post-carousel' ),
										'all'           => true,
										'border_radius' => true,
										'show_units'    => true,
										'units'         => array( 'px', '%' ),
										'default'       => array(
											'all'   => '0',
											'style' => 'solid',
											'color' => '#e2e2e2',
											'border_radius' => '0',
											'unit'  => 'px',
										),
									),
									// array(
									// 'id'       => 'post_border_radius_property',
									// 'type'     => 'spacing',
									// 'title'    => __( 'Border Radius', 'post-carousel' ),
									// 'subtitle' => __( 'Set border radius for item.', 'post-carousel' ),
									// 'all'      => true,
									// 'sanitize' => 'spf_pcp_sanitize_number_array_field',
									// 'units'    => array( 'px', '%' ),
									// 'default'  => array(
									// 'all' => '0',
									// ),
									// ),
									array(
										'id'         => 'post_background_type',
										'class'      => 'post_background_type',
										'type'       => 'button_set',
										'title'      => __( 'Background Color Type', 'post-carousel' ),
										'subtitle'   => __( 'Choose an background color type.', 'post-carousel' ),
										'options'    => array(
											'solid'    => __( 'Solid', 'post-carousel' ),
											'gradient' => __( 'Gradient', 'post-carousel' ),
										),
										'default'    => array( 'solid' ),
										'dependency' => array( 'post_content_orientation', 'not-any', 'overlay,overlay-box' ),
									),
									array(
										'id'         => 'post_background_property',
										'type'       => 'color',
										'title'      => __( 'Background', 'post-carousel' ),
										'subtitle'   => __( 'Set background color for the item.', 'post-carousel' ),
										'default'    => 'transparent',
										'dependency' => array( 'post_content_orientation', 'not-any', 'overlay,overlay-box' ),
									),
									array(
										'id'         => 'post_inner_padding_property',
										'type'       => 'spacing',
										'title'      => __( 'Inner Padding', 'post-carousel' ),
										'subtitle'   => __( 'Set inner padding for  item.', 'post-carousel' ),
										'sanitize'   => 'spf_pcp_sanitize_number_array_field',
										'default'    => array(
											'top'    => '0',
											'right'  => '0',
											'bottom' => '0',
											'left'   => '0',
											'unit'   => 'px',
										),
										'title_info' => "<img src='" . SP_PC_URL . "/admin/assets/img/inner_padding.jpg'>",
									),
									array(
										'id'         => 'item_same_height',
										'type'       => 'switcher',
										'class'      => 'pro_only_field',
										'title'      => __( 'Enable Equal Height', 'post-carousel' ),
										'subtitle'   => __( 'Enable to equalize all items height as the tallest one.', 'post-carousel' ),
										'text_on'    => __( 'Enabled', 'post-carousel' ),
										'text_off'   => __( 'Disabled', 'post-carousel' ),
										'default'    => false,
										'text_width' => 100,
										'title_info' => '<div class="spf-img-tag"><img src="' . SP_PC_URL . '/admin/img/visual-info/equalize_members_height.svg" alt="equalize_members_height"></div><div class="spf-info-label img">' . __( 'Enable Equal Height', 'post-carousel' ) . '</div>',
									),
									array(
										'id'         => 'show_preloader',
										'type'       => 'switcher',
										'title'      => __( 'Preloader', 'post-carousel' ),
										'subtitle'   => __( 'Items will be hidden until page load completed.', 'post-carousel' ),
										'text_on'    => __( 'Enabled', 'post-carousel' ),
										'text_off'   => __( 'Disabled', 'post-carousel' ),
										'text_width' => 100,
										'default'    => false,
									),
								),
							),
							array(
								'title'  => __( 'Content Fields', 'post-carousel' ),
								'icon'   => '<i class="sps-icon-content-1" aria-hidden="true"></i>',
								'fields' => array(
									array(
										'id'       => 'post_content_sorter',
										'type'     => 'sortable',
										'title'    => __( 'Content Fields', 'post-carousel' ),
										'subtitle' => __( 'Item content fields which are draggable to change display order and it\'s settings.', 'post-carousel' ),
										// 'desc'     => __( 'To show Social Share and Custom Fields, <a href="https://smartpostshow.com/" target="_blank"><strong>Upgrade To Pro!</strong></a>', 'post-carousel' ),
										'class'    => 'post_content_sorter',
										'fields'   => array(
											array(
												'id'   => 'pcp_post_thumb',
												'type' => 'accordion',
												'accordions' => array(
													array(
														'title'  => __( 'Image', 'post-carousel' ),
														'fields' => array(
															array(
																'id'       => 'post_thumb_show',
																'type'     => 'switcher',
																'title'    => __( 'Featured Image', 'post-carousel' ),
																'text_on'  => __( 'Show', 'post-carousel' ),
																'text_off' => __( 'Hide', 'post-carousel' ),
																'default'  => true,
																'text_width' => 80,
															),
															array(
																'id'      => 'pcp_thumb_sizes',
																'type'    => 'image_sizes',
																'title'   => __( 'Size', 'post-carousel' ),
																'default' => 'full',
																'dependency' => array( 'post_thumb_show', '==', 'true', true ),
															),
															array(
																'id'       => 'pcp_image_crop_size',
																'type'     => 'dimensions_advanced',
																'title'    => __( 'Custom Size (Pro)', 'post-carousel' ),
																'chosen'   => true,
																'bottom'   => false,
																'left'     => false,
																'color'    => false,
																'top_icon' => '<i class="fa fa-arrows-h"></i>',
																'right_icon' => '<i class="fa fa-arrows-v"></i>',
																'top_placeholder' => 'width',
																'right_placeholder' => 'height',
																'styles'   => array(
																	'Soft-crop',
																	'Hard-crop',
																),
																'default'  => array(
																	'top'  => '600',
																	'right' => '400',
																	'style' => 'Soft-crop',
																	'unit' => 'px',
																),
																'attributes' => array(
																	'min' => 0,
																),
																'dependency' => array( 'post_thumb_show|pcp_thumb_sizes', '==|==', 'true|custom' ),
															),
															array(
																'id'       => 'load_2x_image',
																'type'     => 'switcher',
																'title'    => __( 'Load 2x Resolution Image in Retina Display', 'post-carousel' ),
																'class' => 'pro_only_field',
																'text_on'  => __( 'Enabled', 'post-carousel' ),
																'text_off' => __( 'Disabled', 'post-carousel' ),
																'text_width' => 100,
																'default'  => false,
																'dependency' => array( 'post_thumb_show|pcp_thumb_sizes', '==|==', 'true|custom' ),
															),
															array(
																'id'   => 'pcp_thumb_src_replace',
																'type' => 'checkbox',
																'only_pro' => true,
																'class' => 'pro-overlay-options',
																'title' => __( 'Replace With', 'post-carousel' ),
																'title_help' => __( 'This option will replace your default/featured post image with first resource ( image/video/audio ) from the content.', 'post-carousel' ),
																'options' => array(
																	'image' => __( 'Image', 'post-carousel' ),
																	'video' => __( 'Video', 'post-carousel' ),
																	'audio' => __( 'Audio', 'post-carousel' ),
																),
																'dependency' => array( 'post_thumb_show', '==', 'true' ),
															),
															array(
																'id' => 'pcp_thumb_border',
																'type' => 'border',
																'title' => __( 'Border', 'post-carousel' ),
																'all' => true,
																'border_radius' => true,
																'show_units' => true,
																'units'      => array( 'px', '%' ),
																'default' => array(
																	'all' => '0',
																	'style' => 'solid',
																	'color' => '#dddddd',
																	'border_radius' => '0',
																	'unit' => 'px',
																),
																'dependency' => array( 'post_thumb_show', '==', 'true', true ),
															),
															array(
																'id'   => 'post_thumb_zoom',
																'type' => 'select',
																'only_pro' => true,
																'class' => 'pro-overlay-options-select',
																'title' => __( 'Zoom Effect', 'post-carousel' ),
																'options' => array(
																	'none' => __( 'Normal', 'post-carousel' ),
																	'1' => __( 'Zoom In (Pro)', 'post-carousel' ),
																	'2' => __( 'Zoom Out (Pro)', 'post-carousel' ),
																),
																'default' => 'none',
																'dependency' => array( 'post_thumb_show', '==', 'true' ),
															),
															array(
																'id'   => 'post_thumb_gray_scale',
																'type' => 'select',
																'only_pro' => true,
																'title' => __( 'Image Mode', 'post-carousel' ),
																'class' => 'pro-overlay-options-select',
																'options' => array(
																	'none' => __( 'Original', 'post-carousel' ),
																	'1' => __( 'Grayscale and normal on hover (Pro)', 'post-carousel' ),
																	'2' => __( 'Grayscale on hover (Pro)', 'post-carousel' ),
																	'3' => __( 'Always grayscale (Pro)', 'post-carousel' ),
																),
																'default' => 'none',
																'dependency' => array( 'post_thumb_show', '==', 'true' ),
															),
															array(
																'id'   => 'pcp_img_lazy_load',
																'type' => 'switcher',
																'only_pro' => true,
																'class' => 'pro_only_field',
																'title' => __( 'Lazy Load', 'post-carousel' ),
																'title_info' => __( 'Deferring the loading of images until they are needed significantly improves the page load time.', 'post-carousel' ),
																'default' => true,
																'text_on' => __( 'Enabled', 'post-carousel' ),
																'text_off' => __( 'Disabled', 'post-carousel' ),
																'text_width' => 100,
															),
															array(
																'type' => 'notice',
																'class'    => 'taxonomy-ajax-filter-notice',
																'content' => __( 'To enhance the Featured Image using advanced customizations?', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
															),
														),
													),
												),
											),
											array(
												'id'   => 'pcp_post_title',
												'type' => 'accordion',
												'accordions' => array(
													array(
														'title'  => 'Title',
														'fields' => array(
															array(
																'id'   => 'show_post_title',
																'type' => 'switcher',
																'title' => __( 'Title', 'post-carousel' ),
																'text_on' => __( 'Show', 'post-carousel' ),
																'text_off' => __( 'Hide', 'post-carousel' ),
																'default' => true,
																'text_width' => 80,
															),
															array(
																'id'   => 'post_title_tag',
																'type' => 'select',
																'title' => __( 'HTML Tag for Title', 'post-carousel' ),
																'options' => array(
																	'h1'  => __( 'h1', 'post-carousel' ),
																	'h2'  => __( 'h2', 'post-carousel' ),
																	'h3'  => __( 'h3', 'post-carousel' ),
																	'h4'  => __( 'h4', 'post-carousel' ),
																	'h5'  => __( 'h5', 'post-carousel' ),
																	'h6'  => __( 'h6', 'post-carousel' ),
																	'p'   => __( 'p', 'post-carousel' ),
																	'div' => __( 'div', 'post-carousel' ),
																),
																'default' => 'h2',
																'class' => 'chosen',
																'dependency' => array( 'show_post_title', '==', 'true', true ),
															),
															array(
																'id'   => 'post_title_limit',
																'type' => 'button_set',
																'title' => __( 'Title Display Type', 'post-carousel' ),
																'only_pro' => true,
																'options' => array(
																	'full-title'  => __( 'Full', 'post-carousel' ),
																	'limit-title'  => __( 'Limit', 'post-carousel' ),
																),
																'default' => 'full-title',
																'dependency' => array( 'show_post_title', '==', 'true' ),
															),
															array(
																'id'   => 'pcp_title_length',
																'class'   => 'pcp_title_length',
																'only_pro' => true,
																'type' => 'spacing',
																'title' => __( 'Length', 'post-carousel' ),
																'desc' => __( 'To limit the Title,', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
																'units' => array( 'characters (pro)', 'words (pro)' ),
																'all' => true,
																'all_icon' => '',
																'top' => false,
																'right' => false,
																'bottom' => false,
																'left' => false,
																'default' => array(
																	'all' => '30',
																	'unit' => 'characters (pro)',
																),
																'dependency' => array( 'post_title_limit|show_post_title', '==|==', 'limit-title|true' ),
															),
														),
													),
												),
											),
											array(
												'id'    => 'pcp_post_meta',
												'class' => 'pcp_post_meta sp-product-not-fields',
												'type'  => 'accordion',
												'accordions' => array(
													array(
														'title'  => __( 'Meta Data', 'post-carousel' ),
														'fields' => array(
															array(
																'id'   => 'show_post_meta',
																'type' => 'switcher',
																'title' => __( 'Meta Fields', 'post-carousel' ),
																'text_on' => __( 'Show', 'post-carousel' ),
																'text_off' => __( 'Hide', 'post-carousel' ),
																'default' => true,
																'text_width' => 80,
															),
															array(
																'id'   => 'pcp_post_meta_group',
																'class' => 'pcp_custom_group_design',
																'type' => 'group',
																'button_title' => __( 'Add New Meta', 'post-carousel' ),
																'dependency' => array( 'show_post_meta', '==', 'true' ),
																'fields' => array(
																	array(
																		'id'       => 'select_post_meta',
																		'type'     => 'select',
																		'title'    => __( 'Select Meta', 'post-carousel' ),
																		'placeholder' => __( 'Select a meta', 'post-carousel' ),
																		'class' => 'pcp-meta-select',
																		'options'  => array(
																			'author'  => __( 'Author', 'post-carousel' ),
																			'date'   => __( 'Date', 'post-carousel' ),
																			'comment_count'  => __( 'Comment Count', 'post-carousel' ),
																			'taxonomy'   => __( 'Taxonomy (Pro)', 'post-carousel' ),
																			'view_count' => __( 'View Count (Pro)', 'post-carousel' ),
																			'like'     => __( 'Like (Pro)', 'post-carousel' ),
																			'reading_time'     => __( 'Reading Time (Pro)', 'post-carousel' ),
																		),
																	),
																	array(
																		'id'      => 'post_meta_author_avatar',
																		'type'    => 'select',
																		'title'   => __( 'Avatar', 'post-carousel' ),
																		'class'   => 'post_meta_author_avatar',
																		'options' => array(
																			'show_name' => __( 'Show name', 'post-carousel' ),
																			'show_gravatar' => __( 'Show gravatar', 'post-carousel' ),
																			'name_with_gravatar' => __( 'Author name & gravatar', 'post-carousel' ),
																			'name_with_icon' => __( 'Author name with an icon', 'post-carousel' ),

																		),
																		'desc' => sprintf(
																			/* translators: 1: start link and em tag, 2: close tags. */
																			__( 'To show gravatar, you must %1$senable it%2$s.', 'post-carousel' ),
																			'<a href="https://wordpress.org/support/article/how-to-use-gravatars/" target="_blank" rel="noopener noreferrer nofollow"><em>',
																			'</em></a>'
																		),
																		'default' => 'name_with_icon',
																		'dependency' => array( 'select_post_meta', '==', 'author' ),
																	),
																	array(
																		'id'      => 'post_meta_date_format',
																		'type'    => 'select',
																		'title'   => __( 'Date Format', 'post-carousel' ),
																		'class'   => 'post_meta_date_format',
																		'options' => array(
																			'default' => __( 'Default', 'post-carousel' ),
																			'time_ago' => __( 'Time ago(human time)', 'post-carousel' ),
																			'custom' => __( 'Custom', 'post-carousel' ),
																		),
																		'default' => 'default',
																		'dependency' => array( 'select_post_meta', '==', 'date' ),
																	),
																	array(
																		'id'    => 'pcp_custom_meta_date_format',
																		'type'  => 'text',
																		'title' => ' ',
																		'class' => 'pcp_custom_meta_date_format',
																		'placeholder' => __( 'F j, Y', 'post-carousel' ),
																		'default'   => __( 'F j, Y', 'post-carousel' ),
																		'desc' => sprintf(
																			/* translators: 1: start link and em tag, 2: close tags. */
																			__( 'To define format, check %1$sthis doc%2$s.', 'post-carousel' ),
																			'<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank" rel="noopener noreferrer nofollow"><em>',
																			'</em></a>'
																		),
																		'dependency' => array( 'select_post_meta|post_meta_date_format', '==|==', 'date|custom' ),
																	),
																	array(
																		'id'      => 'post_meta_taxonomy',
																		'type'    => 'select',
																		'title'   => __( 'Select Taxonomy', 'post-carousel' ),
																		'class'   => 'post_meta_taxonomy',
																		'options' => 'taxonomy',
																		'query_args' => array(
																			'type' => 'any',
																		),
																		'attributes' => array(
																			'style' => 'width: 200px;',
																		),
																		'empty_message' => __( 'No taxonomies found.', 'post-carousel' ),
																		'dependency' => array( 'select_post_meta', '==', 'taxonomy' ),
																	),
																	array(
																		'id'      => 'pcp_meta_position',
																		'class'      => 'pcp_meta_position',
																		'type'    => 'button_set',
																		'title'   => __( 'Position', 'post-carousel' ),
																		'options' => array(
																			'beside_meta' => __( 'Beside Other Meta', 'post-carousel' ),
																			'above_title' => __( 'Above Title', 'post-carousel' ),
																			'over_thumb' => __( 'Over Thumbnail', 'post-carousel' ),

																		),
																		'default' => 'beside_meta',
																		'dependency' => array( 'select_post_meta', '==', 'taxonomy' ),
																	),
																	array(
																		'id'      => 'pcp_meta_over_thump_position',
																		'type'    => 'select',
																		'title'   => __( 'Over Thumbnail Position', 'post-carousel' ),
																		'options' => array(
																			'top_left' => __( 'Top Left', 'post-carousel' ),
																			'top_right' => __( 'Top Right', 'post-carousel' ),
																			'bottom_left' => __( 'Bottom Left', 'post-carousel' ),
																			'bottom_right' => __( 'Bottom Right', 'post-carousel' ),
																		),
																		'default' => 'top_left',
																		'dependency' => array( 'select_post_meta|pcp_meta_position', '==|==', 'taxonomy|over_thumb' ),
																	),
																	array(
																		'id'      => 'pcp_meta_pill_color',
																		'type'    => 'color_group',
																		'title'   => __( 'Meta Color', 'post-carousel' ),
																		'options' => array(
																			'text' => __( 'Text', 'post-carousel' ),
																			'bg' => __( 'Background', 'post-carousel' ),
																		),
																		'default' => array(
																			'text' => '#fff',
																			'bg' => '#e53935',
																		),
																		'dependency' => array( 'select_post_meta|pcp_meta_position', '==|!=', 'taxonomy|beside_meta' ),
																	),
																	array(
																		'id'      => 'pcp_word_per_minute',
																		'type'    => 'number',
																		'title'   => __( 'Per Minute', 'post-carousel' ),
																		'class'   => 'pcp_reading_time_meta',
																		'title_help'   => __( 'Default 300 words, the average reading speed for adults.', 'post-carousel' ),
																		'sanitize'        => 'pcp_sanitize_number_field',
																		'unit'   => __( 'words', 'post-carousel' ),
																		'default' => '300',
																		'dependency' => array( 'select_post_meta', '==', 'reading_time' ),
																		'default' => 300,
																	),
																	array(
																		'id'      => 'select_meta_icon',
																		'class'      => 'select_meta_icon',
																		'type'    => 'icon',
																		'title'   => __( 'Meta Icon', 'post-carousel' ),
																		'default' => 'fa fa-folder-o',
																		'dependency' => array( 'pcp_meta_position|select_post_meta', '==|!=', 'beside_meta|like' ),
																	),
																	array(
																		'id'      => 'reading_time_postfix',
																		'type'    => 'text',
																		'title'   => __( 'Reading Time Postfix', 'post-carousel' ),
																		'class'   => 'pcp_reading_time_postfix',
																		'title_help'   => __( 'Text after time. Leave empty for nothing.', 'post-carousel' ),
																		'default' => ' Min Read',
																		'dependency' => array( 'select_post_meta', '==', 'reading_time' ),
																	),
																),
																'default' => array(
																	array(
																		'select_post_meta'    => 'author',
																		'post_meta_author_avatar'    => 'name_with_icon',
																		'select_meta_icon'    => 'fa fa-user',
																		'pcp_meta_position'     => 'beside_meta',
																	),
																	array(
																		'select_post_meta'     => 'date',
																		'select_meta_icon'    => 'fa fa-calendar',
																		'pcp_meta_position'     => 'beside_meta',
																	),
																	array(
																		'select_post_meta'     => 'comment_count',
																		'select_meta_icon'    => 'fa fa-comments-o',
																		'pcp_meta_position'     => 'beside_meta',
																	),
																),
															),
															array(
																'id'   => 'meta_separator',
																'type' => 'radio',
																'title' => __( 'Meta Separator', 'post-carousel' ),
																'only_pro' => true,
																'options' => array(
																	' '  => __( 'Normal Space ', 'post-carousel' ),
																	'. ' => __( 'Full Stop ( . ) ', 'post-carousel' ),
																	'| ' => __( 'Straight Line ( | )', 'post-carousel' ),
																	'/ ' => __( 'Slash ( / )', 'post-carousel' ),
																	'\ ' => __( 'Back Slash( \\ )', 'post-carousel' ),
																),
																'default' => ' ',
																'dependency' => array( 'show_post_meta', '==', 'true' ),
															),
															array(
																'type' => 'notice',
																'class'    => 'taxonomy-ajax-filter-notice',
																'content' => __( 'To access more Meta Data and options,', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
															),
														),
													),
												),
											),
											array(
												'id'   => 'pcp_post_content',
												'type' => 'accordion',
												'accordions' => array(
													array(
														'title'  => 'Content',
														'fields' => array(
															array(
																'id'   => 'show_post_content',
																'type' => 'switcher',
																'title' => __( 'Content', 'post-carousel' ),
																'text_on' => __( 'Show', 'post-carousel' ),
																'text_off' => __( 'Hide', 'post-carousel' ),
																'default' => true,
																'text_width' => 80,
															),
															array(
																'id'   => 'post_content_type',
																'type' => 'button_set',
																'class' => 'pcp-post-content-type',
																'title' => __( 'Content Display Type', 'post-carousel' ),
																'options' => array(
																	'excerpt'      => __( 'Excerpt', 'post-carousel' ),
																	'limit_content' => __( 'Limit', 'post-carousel' ),
																	'full_content' => __( 'Full', 'post-carousel' ),
																),
																'default' => 'excerpt',
																'dependency' => array( 'show_post_content', '==', 'true', true ),
															),
															array(
																'id'   => 'pcp_content_length_type',
																'class'   => 'pcp_content_length_type',
																'type' => 'spacing',
																'only_pro'   => true,
																'title' => __( 'Length', 'post-carousel' ),
																'units' => array( 'words (Pro)', 'characters (Pro)' ),
																'all' => true,
																'all_icon' => '',
																'top' => false,
																'right' => false,
																'bottom' => false,
																'left' => false,
																'default' => array(
																	'all' => '30',
																	'unit' => 'words',
																),
																'dependency' => array( 'show_post_content|post_content_type', '==|==', 'true|limit_content' ),
															),
															array(
																'id'   => 'pcp_strip_tags',
																'type' => 'radio',
																'title' => __( 'HTML Tags', 'post-carousel' ),
																'only_pro'   => true,
																'class'   => 'only_pro_field',
																'options' => array(
																	'allow_all'  => __( 'Allow All', 'post-carousel' ),
																	'strip_all'  => __( 'Strip All', 'post-carousel' ),
																	'allow_some' => __( 'Allow Some', 'post-carousel' ),
																),
																'default' => 'allow_all',
																'dependency' => array( 'show_post_content|post_content_type', '==|!=', 'true|excerpt' ),
															),

															// ReadMore settings.
															array(
																'id'   => 'show_read_more',
																'type' => 'switcher',
																'title' => __( 'Read More', 'post-carousel' ),
																'text_on' => __( 'Show', 'post-carousel' ),
																'text_off' => __( 'Hide', 'post-carousel' ),
																'default' => true,
																'text_width' => 80,
																'dependency' => array( 'post_content_type', '!=', 'full_content', true ),
															),
															array(
																'id'   => 'pcp_read_label',
																'type' => 'text',
																'title' => __( 'Read More Label', 'post-carousel' ),
																'default' => 'Read More',
																'dependency' => array( 'post_content_type|show_read_more', '!=|==', 'full_content|true', true ),
															),
															array(
																'id'   => 'readmore_color_button',
																'type' => 'color_group',
																'title' => __( 'Read More Color', 'post-carousel' ),
																'options' => array(
																	'standard' => __( 'Text Color', 'post-carousel' ),
																	'hover' => __( 'Text Hover Color', 'post-carousel' ),
																	'bg' => __( 'Background', 'post-carousel' ),
																	'hover_bg' => __( 'Hover Background', 'post-carousel' ),
																	// 'border' => __( 'Border', 'post-carousel' ),
																	// 'hover_border' => __( 'Hover Border', 'post-carousel' ),
																),
																'default' => array(
																	'standard' => '#111',
																	'hover' => '#fff',
																	'bg' => 'transparent',
																	'hover_bg' => '#e1624b',
																	// 'border' => '#888',
																	// 'hover_border' => '#e1624b',
																),
																'dependency' => array( 'post_content_type|show_read_more', '!=|==', 'full_content|true', true ),
															),

															array(
																'id'            => 'read_more_btn_border',
																'type'          => 'border',
																'title'         => __( 'Border', 'post-carousel' ),
																'subtitle'      => __( 'Set border for the read more button.', 'post-carousel' ),
																'all'           => true,
																'border_radius' => true,
																'hover_color' => true,
																'show_units'    => true,
																'units'         => array( 'px', '%' ),
																'default'       => array(
																	'all'   => '1',
																	'style' => 'solid',
																	'color' => '#888',
																	'hover_color' => '#e1624b',
																	'border_radius' => '0',
																	'unit'  => 'px',
																),
																'dependency' => array( 'post_content_type|show_read_more', '!=|==', 'full_content|true', true ),
															),
															array(
																'type' => 'notice',
																'class'    => 'taxonomy-ajax-filter-notice',
																'content' => __( 'To limit the Content and more options,', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
															),
														),
													),
												),
											),
											array(
												'id'   => 'pcp_social_share',
												'type' => 'accordion',
												// 'class' => 'pcp-pro-only',
												'accordions' => array(
													array(
														'title'  => __( 'Social Share', 'post-carousel' ),
														'fields' => array(
															array(
																'type' => 'notice',
																'class'    => 'taxonomy-ajax-filter-notice',
																'content' => __( 'To unlock the following social share options,', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
															),
															array(
																'id'      => 'pcp_set_social',
																'type'    => 'text',
																'class'     => 'pcp_set_adv',
																'title'   => '',
																'url' => SP_PC_URL . 'admin/img/spc-ss/social.webp',
																'only_pro' => true,
															),
															array(
																'id'   => 'social_position',
																'type' => 'button_set',
																'title' => __( 'Alignment', 'post-carousel' ),
																'options' => array(
																	'left' => '<i class="fa fa-align-left" title="Left"></i>',
																	'center' => '<i class="fa fa-align-center" title="Center"></i>',
																	'right' => '<i class="fa fa-align-right" title="Right"></i>',
																),
																'default' => 'left',
																'dependency' => array( 'social_sharing_media', '!=', '' ),
															),
														),
													),
												),
											), // PCP Post Social.
											array(
												'id'   => 'pcp_custom_fields',
												'type' => 'accordion',
												'accordions' => array(
													array(
														'title'  => __( 'Custom Fields', 'post-carousel' ),
														'fields' => array(
															array(
																'type' => 'notice',
																'class'    => 'taxonomy-ajax-filter-notice',
																'content' => __( 'To unlock the following amazing custom field options,', 'post-carousel' ) . ' <a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>' . __( 'Upgrade To Pro!', 'post-carousel' ) . '</b></a>',
															),
															array(
																'id'      => 'pcp_set_custom_fields',
																'type'    => 'text',
																'class'     => 'pcp_set_adv',
																'title'   => '',
																'url' => SP_PC_URL . 'admin/img/spc-ss/custom-field.webp',
																'only_pro' => true,
															),
															array(
																'id'   => 'customize_custom_field_name',
																'type' => 'text',
																'title' => __( 'Customize Field Name', 'smart-post-show-pro' ),
																'dependency' => array( 'show_custom_field_name', '==', 'true' ),
															),

														), // End Fields array.
													),
												), // Accordion.
											), // Custom fields end.
										),
									),
								),
							),
							array(
								'title'  => __( 'Load More Pagination', 'post-carousel' ),
								'class'  => 'pcp_ajax_pagination',
								'icon'   => '<i class="sps-icon-ajax" aria-hidden="true"></i>',
								'fields' => array(
									array(
										'id'         => 'show_post_pagination',
										'type'       => 'switcher',
										'text_on'    => __( 'Enabled', 'post-carousel' ),
										'text_off'   => __( 'Disabled', 'post-carousel' ),
										'text_width' => 100,
										'title'      => __( 'Pagination', 'post-carousel' ),
										'subtitle'   => __( 'Enabled/Disabled item pagination.', 'post-carousel' ),
										'default'    => true,
										'dependency' => array( 'pcp_layout_preset', 'not-any', 'carousel_layout', 'true' ),
									),
									array(
										'id'         => 'post_pagination_type',
										'type'       => 'radio',
										'title'      => __( 'Pagination Type', 'post-carousel' ),
										'subtitle'   => __( 'Choose a pagination type.', 'post-carousel' ),
										'desc'       => sprintf(
											/* translators: 1: start link and strong tag, 2: close tags. */
											__( 'More amazing Ajax Pagination Settings are available in %1$sPro%2$s', 'post-carousel' ),
											'<a href="https://smartpostshow.com/" target="_blank"><strong>',
											'</strong></a>!'
										),
										'class'      => 'pcp-pagination-type',
										'options'    => array(
											'no_ajax' => __( 'Normal Pagination', 'post-carousel' ),
											'ajax_load_more' => __( 'Ajax Load More Button (Pro)', 'post-carousel' ),
											'ajax_pagination' => __( 'Ajax Number Pagination (Pro)', 'post-carousel' ),
											'infinite_scroll' => __( 'Ajax Infinite Scroll (Pro)', 'post-carousel' ),
										),
										'default'    => 'no_ajax',
										'dependency' => array( 'pcp_layout_preset|show_post_pagination', 'not-any|==', 'carousel_layout|true', true ),
									),
									array(
										'id'         => 'post_per_page',
										'type'       => 'spinner',
										'title'      => __( 'Items Per Page', 'post-carousel' ),
										'subtitle'   => __( 'Set number of items to show per page.', 'post-carousel' ),
										'title_info' => sprintf(
											/* translators: 1: start strong tag, 2: close tags. */
											__( 'This value should be lesser than that %1$s Limit %2$s from %1$sFilter Content  %2$s tab.', 'post-carousel' ),
											'<strong>',
											'</strong>'
										),
										'default'    => 12,
										'dependency' => array( 'pcp_layout_preset|show_post_pagination', 'not-any|==', 'carousel_layout|true', true ),
									),
									array(
										'id'         => 'post_load_per_click',
										'type'       => 'spinner',
										'class'      => 'pcp_only_pro',
										'title'      => __( 'Items Load Per Click', 'post-carousel' ),
										'subtitle'   => __( 'Set number of items to load per click.', 'post-carousel' ),
										'sanitize'   => 'pcp_sanitize_number_field',
										'default'    => 12,
										'dependency' => array( 'show_post_pagination', '==', 'true', true ),
									),
									array(
										'id'         => 'pcp_pagination_btn_color',
										'type'       => 'color_group',
										'sanitize'   => 'spf_pcp_sanitize_color_group_field',
										'title'      => __( 'Color', 'post-carousel' ),
										'subtitle'   => __( 'Set Pagination color', 'post-carousel' ),
										'options'    => array(
											'text_color'  => __( 'Text Color', 'post-carousel' ),
											'text_acolor' => __( 'Text Active Color', 'post-carousel' ),
											// 'border_color' => __( 'Border Color', 'post-carousel' ),
											// 'border_acolor' => __( 'Border Active Color', 'post-carousel' ),
											'background'  => __( 'Background', 'post-carousel' ),
											'active_background' => __( 'Active BG', 'post-carousel' ),
										),
										'default'    => array(
											'text_color'  => '#5e5e5e',
											'text_acolor' => '#ffffff',
											// 'border_color' => '#bbbbbb',
											// 'border_acolor' => '#e1624b',
											'background'  => '#ffffff',
											'active_background' => '#e1624b',
										),
										'dependency' => array( 'pcp_layout_preset|show_post_pagination|post_pagination_type', '!=|==|any', 'carousel_layout|true|ajax_pagination,no_ajax', true ),
									),
									array(
										'id'            => 'pcp_pagination_btn_border',
										'type'          => 'border',
										'title'         => __( 'Border', 'post-carousel' ),
										'subtitle'      => __( 'Set border for the pagination button.', 'post-carousel' ),
										'all'           => true,
										'border_radius' => true,
										'hover_color'   => true,
										'show_units'    => true,
										'units'         => array( 'px', '%' ),
										'sanitize'      => 'spf_pcp_sanitize_border_field',
										'default'       => array(
											'all'         => '2',
											'style'       => 'solid',
											'color'       => '#bbbbbb',
											'hover_color' => '#e1624b',
											'border_radius' => '2',
											'unit'        => 'px',
										),
										'dependency'    => array( 'pcp_layout_preset|show_post_pagination|post_pagination_type', '!=|==|!=', 'carousel_layout|true|infinite_scroll', true ),
									),
									array(
										'id'         => 'pagination_alignment',
										'type'       => 'button_set',
										'title'      => __( 'Alignment', 'post-carousel' ),
										'subtitle'   => __( 'Choose pagination alignment.', 'post-carousel' ),
										'options'    => array(
											'left'   => '<i class="fa fa-align-left" title="Left"></i>',
											'center' => '<i class="fa fa-align-center" title="Center"></i>',
											'right'  => '<i class="fa fa-align-right" title="Right"></i>',
										),
										'default'    => 'left',
										'dependency' => array( 'pcp_layout_preset|show_post_pagination|post_pagination_type', '!=|==|!=', 'carousel_layout|true|infinite_scroll', true ),
									),
								),
							),
							array(
								'title'  => __( 'Advertisement', 'post-carousel' ),
								'icon'   => '<i class="sps-icon-ad" aria-hidden="true"></i>',
								'fields' => array(
									array(
										'type'    => 'notice',
										'class'   => 'taxonomy-ajax-filter-notice',
										'content' => sprintf(
											/* translators: 1: start link and bold tag, 2: close tags. */
											__( 'To earn money from your website by displaying Google AdSense, banners, and more in your posts, %1$sUpgrade To Pro!%2$s', 'post-carousel' ),
											'<a href="https://smartpostshow.com/pricing/?ref=1" target="_blank"><b>',
											'</b></a>'
										),
									),
									array(
										'id'       => 'pcp_set_adv',
										'type'     => 'text',
										'class'    => 'pcp_set_adv',
										'title'    => '',
										'url'      => SP_PC_URL . 'admin/img/spc-ss/adv.webp',
										'only_pro' => true,
									),
									// array(
									// 'id'         => 'show_adv',
									// 'class'      => 'show_adv',
									// 'type'       => 'switcher',
									// 'title'      => __( 'Display Advertisement', 'post-carousel' ),
									// 'subtitle'   => __( 'Show/hide advertisement settings.', 'post-carousel' ),
									// 'text_on'    => __( 'Show', 'post-carousel' ),
									// 'text_off'   => __( 'Hide', 'post-carousel' ),
									// 'text_width' => 80,
									// ),
									// array(
									// 'id'         => 'adv_position',
									// 'type'       => 'radio',
									// 'title'      => __( 'Advertisement Position', 'post-carousel' ),
									// 'subtitle'   => __( 'Set a position for the advertisement.', 'post-carousel' ),
									// 'options'    => array(
									// 'random' => __( 'Random', 'post-carousel' ),
									// 'manual' => __( 'Manual', 'post-carousel' ),
									// ),
									// 'default'    => 'random',
									// 'dependency' => array( 'show_adv', '==', 'true', 'all' ),
									// ),
									// array(
									// 'id'         => 'adv_position_number',
									// 'title'      => __( 'Advertisements Position number', 'post-carousel' ),
									// 'type'       => 'text',
									// 'subtitle'   => __( 'Set numeric positions (separate by comma, in increasing order) to show ads on each page.', 'post-carousel' ),
									// 'default'    => '1',
									// 'min'        => 1,
									// 'dependency' => array( 'show_adv|adv_position', '==|==', 'true|manual', 'all' ),
									// ),
									// array(
									// 'id'         => 'repeat_ads',
									// 'title'      => __( 'Repeat Advertisements', 'post-carousel' ),
									// 'type'       => 'spinner',
									// 'subtitle'   => __( 'Set how many times ads will repeat.', 'post-carousel' ),
									// 'sanitize'   => 'pcp_sanitize_number_field',
									// 'default'    => '1',
									// 'min'        => 1,
									// 'dependency' => array( 'show_adv', '==', 'true', 'all' ),
									// ),
									// array(
									// 'id'           => 'sps_ads',
									// 'type'         => 'group',
									// 'class'        => 'advertisements_group',
									// 'button_title' => __( 'Add New Ads', 'post-carousel' ),
									// 'title'        => __( 'Advertisements', 'post-carousel' ),
									// 'dependency'   => array( 'show_adv', '==', 'true', 'all' ),
									// 'accordion_title_number' => true,
									// 'accordion_title_auto' => false,
									// 'accordion_title_prefix' => __( 'Ads', 'post-carousel' ),
									// 'fields'       => array(
									// array(
									// 'id'       => 'ads_content',
									// 'type'     => 'code_editor',
									// 'settings' => array(
									// 'icon' => 'fa fa-sliders',
									// 'theme' => 'mbo',
									// ),
									// ),
									// ),
									// ),
								),
							),
						),
					),
				), // End of fields array.
			)
		); // Display settings section end.
	}
}
