<?php

namespace DynamicOOOS\TelegramBot\Api\Types;

use DynamicOOOS\TelegramBot\Api\BaseType;
use DynamicOOOS\TelegramBot\Api\TypeInterface;
/**
 * This object represents a unique message identifier.
 */
class MessageId extends BaseType implements TypeInterface
{
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $requiredParams = ['message_id'];
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $map = ['message_id' => \true];
    /**
     * Unique message identifier
     *
     * @var integer
     */
    protected $messageId;
    /**
     * @return int
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * @param int $messageId
     * @return void
     */
    public function setMessageId($messageId)
    {
        $this->messageId = $messageId;
    }
}
